/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.human.dto.MKihonDto;

public class EmployeeAttendanceListVo extends AttendanceMenuVo {

	private static final long serialVersionUID = 159955841494832069L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/employeeAttendanceList.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/employeeAttendanceList.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/employeeAttendanceList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_EMPLOYEE_SELECT;

	// p[^
	public static final String PRM_TXT_K_CODE		= "txtKCode";
	public static final String PRM_TXT_K_NAME		= "txtKName";
	public static final String PRM_PLT_SECTION 	= "pltSection";

	// tB[hyѐ
	public static final String NAM_K_CODE = CommonConst.NAM_K_CODE;

	public static final int	LEN_K_CODE = CommonConst.LEN_K_CODE;
	public static final int	LEN_K_NAME = CommonConst.LEN_K_NAME;

	// tB[h
	private String[] aryKCode;
	private String[] aryKName;
	private String[] arySection;
	private String[] aryPosition;
	private String   txtKCode;
	private String   txtKName;
	private String   pltSection;

	// v_EXg
	public String[][] aryPltSectionAll;
	public String[][] aryPltSection;
	public String[][] aryPltPosition;

	// \[gL[
	public final String KEY_K_CODE        = "keyKCode";
	public final String KEY_K_NAME        = "keyKName";
	public final String KEY_SECTION       = "keySection";
	public final String KEY_POSITION      = "keyPosition";

	/**
	 * RXgN^
	 */
	public EmployeeAttendanceListVo() {
		super();		
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtKCode        = "";
		txtKName        = "";
		pltSection      = "";

		aryKCode        = new String[0];
		aryKName        = new String[0];
		arySection      = new String[0];
		aryPosition     = new String[0];

		setFormerKey(KEY_K_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtKCode        = request.getParameter(PRM_TXT_K_CODE);
		txtKName        = request.getParameter(PRM_TXT_K_NAME);
		pltSection      = request.getParameter(PRM_PLT_SECTION);
	}

	/**
	 * tB[hݒ
	 * @param list ЈXg
	 */
	public void setFields(List list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryKCode        = new String[count];
		aryKName        = new String[count];
		arySection      = new String[count];
		aryPosition     = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			MKihonDto dto = (MKihonDto)it.next();
			aryKCode[i]   = escapeHTML(dto.getKCode());
			aryKName[i]   = escapeHTML(dto.getSimei());
			arySection[i] = "";
			for (int j = 0; j < aryPltSectionAll.length; j++) {
				if (aryPltSectionAll[j][0].equals(dto.getSCode())) {
					arySection[i] = escapeHTML(aryPltSectionAll[j][1]);
					break;
				}
			}
			aryPosition[i] = "";
			for (int j = 0; j < aryPltPosition.length; j++) {
				if (aryPltPosition[j][0].equals(dto.getYCode())
						&& aryPltPosition[j][2].equals(dto.getTokyu())) {
					aryPosition[i] = escapeHTML(aryPltPosition[j][1]);
					break;
				}
			}
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryKCode		() { return aryKCode.clone()	; }
	public String[] getEscAryKName		() { return aryKName.clone()	; }
	public String[] getEscArySection	() { return arySection.clone()	; }
	public String[] getEscAryPosition	() { return aryPosition.clone()	; }

	public String getTxtKCode	() { return txtKCode	; }
	public String getTxtKName	() { return txtKName	; }
	public String getPltSection	() { return pltSection	; }

	public String getEscTxtKCode	() { return escapeHTML(txtKCode		); }
	public String getEscTxtKName	() { return escapeHTML(txtKName		); }
	public String getEscPltSection	() { return escapeHTML(pltSection	); }

	public void setPltSection(String pltSection) { this.pltSection = pltSection; }

}
